/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.io.File;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.impl.VfsRootReference;
import org.gradle.internal.watch.registry.WatchMode;
import org.gradle.internal.watch.vfs.BuildFinishedFileSystemWatchingBuildOperationType;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.BuildStartedFileSystemWatchingBuildOperationType;
import org.gradle.internal.watch.vfs.FileSystemWatchingInformation;
import org.gradle.internal.watch.vfs.VfsLogging;
import org.gradle.internal.watch.vfs.WatchLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchingNotSupportedVirtualFileSystem
extends AbstractVirtualFileSystem
implements BuildLifecycleAwareVirtualFileSystem,
FileSystemWatchingInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchingNotSupportedVirtualFileSystem.class);

    public WatchingNotSupportedVirtualFileSystem(VfsRootReference rootReference) {
        super(rootReference);
    }

    protected SnapshotHierarchy updateNotifyingListeners(AbstractVirtualFileSystem.UpdateFunction updateFunction) {
        return updateFunction.update(SnapshotHierarchy.NodeDiffListener.NOOP);
    }

    @Override
    public boolean afterBuildStarted(WatchMode watchMode, VfsLogging vfsLogging, WatchLogging watchLogging, BuildOperationRunner buildOperationRunner) {
        if (watchMode == WatchMode.ENABLED) {
            LOGGER.warn("Watching the file system is not supported.");
        }
        this.rootReference.updateUnderLock(vfsRoot -> (SnapshotHierarchy)buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<SnapshotHierarchy>(){

            public SnapshotHierarchy call(BuildOperationContext context) {
                context.setResult((Object)BuildStartedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return vfsRoot.empty();
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build started for file system watching").details((Object)BuildStartedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
        return false;
    }

    @Override
    public void registerWatchableHierarchy(File rootDirectoryForWatching) {
    }

    @Override
    public void beforeBuildFinished(WatchMode watchMode, VfsLogging vfsLogging, WatchLogging watchLogging, BuildOperationRunner buildOperationRunner, int maximumNumberOfWatchedHierarchies) {
        this.rootReference.updateUnderLock(vfsRoot -> (SnapshotHierarchy)buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<SnapshotHierarchy>(){

            public SnapshotHierarchy call(BuildOperationContext context) {
                context.setResult((Object)BuildFinishedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return vfsRoot.empty();
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build finished for file system watching").details((Object)BuildFinishedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
    }

    @Override
    public boolean isWatchingAnyLocations() {
        return false;
    }
}

