/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsIdentifierChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "js.frontend"})
public final class JsIdentifierChecker
implements IdentifierChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public JsIdentifierChecker(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        boolean hasIllegalChars;
        block6: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
            Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
                return;
            }
            String simpleName = simpleNameExpression.getReferencedName();
            char[] cArray = new char[]{'.'};
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)simpleName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(it), (Object)it))) continue;
                    bl = true;
                    break block6;
                }
                bl = hasIllegalChars = false;
            }
        }
        if (hasIllegalChars) {
            PsiElement psiElement = simpleNameExpression.getIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(identifier, "contains illegal characters"));
        }
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
    }
}

